/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analytics.facet.AnalyticsFacet;
import org.apache.solr.analytics.facet.PivotNode;
import org.apache.solr.analytics.facet.StreamingFacet;
import org.apache.solr.analytics.function.ExpressionCalculator;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.common.util.NamedList;

public class PivotFacet
extends AnalyticsFacet
implements StreamingFacet {
    private final PivotHead<?> pivotHead;

    public PivotFacet(String name, PivotNode<?> topPivot) {
        super(name);
        this.pivotHead = new PivotHead(topPivot);
    }

    @Override
    public void setReductionCollectionManager(ReductionCollectionManager collectionManager) {
        this.pivotHead.setReductionCollectionManager(collectionManager);
    }

    @Override
    public void setExpressionCalculator(ExpressionCalculator expressionCalculator) {
        this.pivotHead.setExpressionCalculator(expressionCalculator);
    }

    @Override
    public void addFacetValueCollectionTargets() {
        this.pivotHead.addFacetValueCollectionTargets();
    }

    @Override
    public void importShardData(DataInput input) throws IOException {
        this.pivotHead.importShardData(input);
    }

    @Override
    public void exportShardData(DataOutput output) throws IOException {
        this.pivotHead.exportShardData(output);
    }

    @Override
    public NamedList<Object> createOldResponse() {
        return new NamedList();
    }

    @Override
    public Iterable<Map<String, Object>> createResponse() {
        return this.pivotHead.createResponse();
    }

    private static class PivotHead<T>
    implements StreamingFacet {
        private final PivotNode<T> topPivot;
        private final Map<String, T> pivotValues;

        public PivotHead(PivotNode<T> topPivot) {
            this.topPivot = topPivot;
            this.pivotValues = new HashMap<String, T>();
        }

        public void setReductionCollectionManager(ReductionCollectionManager collectionManager) {
            this.topPivot.setReductionCollectionManager(collectionManager);
        }

        public void setExpressionCalculator(ExpressionCalculator expressionCalculator) {
            this.topPivot.setExpressionCalculator(expressionCalculator);
        }

        @Override
        public void addFacetValueCollectionTargets() {
            this.topPivot.addFacetValueCollectionTargets(this.pivotValues);
        }

        public void importShardData(DataInput input) throws IOException {
            this.topPivot.importPivot(input, this.pivotValues);
        }

        public void exportShardData(DataOutput output) throws IOException {
            this.topPivot.exportPivot(output, this.pivotValues);
        }

        public Iterable<Map<String, Object>> createResponse() {
            return this.topPivot.getPivotedResponse(this.pivotValues);
        }
    }
}

