/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;

public class InjectionFactories {

    public static class SingletonFactory<T>
    implements Factory<T> {
        private final T singletonVal;

        public SingletonFactory(T singletonVal) {
            this.singletonVal = singletonVal;
        }

        public T provide() {
            return this.singletonVal;
        }

        public void dispose(T instance) {
        }
    }

    public static class RequestContextBasedFactory {
        @Context
        ServiceLocator serviceLocator;

        public ContainerRequestContext getRequestContext() {
            return (ContainerRequestContext)this.serviceLocator.getService(ContainerRequestContext.class, new Annotation[0]);
        }
    }

    public static class ReuseFromContextSolrParamsFactory
    extends RequestContextBasedFactory
    implements Factory<SolrParams> {
        public SolrParams provide() {
            return (SolrParams)this.getRequestContext().getProperty(RequestContextKeys.SOLR_PARAMS);
        }

        public void dispose(SolrParams instance) {
        }
    }

    public static class ReuseFromContextIndexSchemaFactory
    implements Factory<IndexSchema> {
        @Context
        ServiceLocator serviceLocator;

        public IndexSchema provide() {
            return this.doProvide((SolrCore)this.serviceLocator.getService(SolrCore.class, new Annotation[0]));
        }

        private IndexSchema doProvide(SolrCore solrCore) {
            return solrCore.getLatestSchema();
        }

        public void dispose(IndexSchema instance) {
        }
    }

    public static class ReuseFromContextSolrCoreFactory
    extends RequestContextBasedFactory
    implements Factory<SolrCore> {
        public SolrCore provide() {
            return (SolrCore)this.getRequestContext().getProperty(RequestContextKeys.SOLR_CORE);
        }

        public void dispose(SolrCore instance) {
        }
    }

    public static class SolrQueryResponseFactory
    extends RequestContextBasedFactory
    implements Factory<SolrQueryResponse> {
        public SolrQueryResponse provide() {
            return (SolrQueryResponse)this.getRequestContext().getProperty(RequestContextKeys.SOLR_QUERY_RESPONSE);
        }

        public void dispose(SolrQueryResponse instance) {
        }
    }

    public static class SolrQueryRequestFactory
    extends RequestContextBasedFactory
    implements Factory<SolrQueryRequest> {
        public SolrQueryRequest provide() {
            return (SolrQueryRequest)this.getRequestContext().getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        }

        public void dispose(SolrQueryRequest instance) {
        }
    }
}

