/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.RateLimiterPayload;
import org.apache.solr.servlet.RateLimitManager;

public class RateLimiterConfig {
    public static final String RL_CONFIG_KEY = "rate-limiters";
    public final SolrRequest.SolrRequestType requestType;
    public final boolean isEnabled;
    public final long waitForSlotAcquisition;
    public final int allowedRequests;
    public final boolean isSlotBorrowingEnabled;
    public final int guaranteedSlotsThreshold;
    public final RateLimiterPayload definition;
    private static final RateLimiterPayload EMPTY = new RateLimiterPayload();

    public RateLimiterConfig(SolrRequest.SolrRequestType requestType) {
        this(requestType, EMPTY);
    }

    public RateLimiterConfig(SolrRequest.SolrRequestType requestType, boolean isEnabled, int guaranteedSlotsThreshold, long waitForSlotAcquisition, int allowedRequests, boolean isSlotBorrowingEnabled) {
        this(requestType, RateLimiterConfig.makePayload(isEnabled, guaranteedSlotsThreshold, waitForSlotAcquisition, allowedRequests, isSlotBorrowingEnabled));
    }

    private static RateLimiterPayload makePayload(boolean isEnabled, int guaranteedSlotsThreshold, long waitForSlotAcquisition, int allowedRequests, boolean isSlotBorrowingEnabled) {
        RateLimiterPayload ret = new RateLimiterPayload();
        ret.enabled = isEnabled;
        ret.allowedRequests = allowedRequests;
        ret.guaranteedSlots = guaranteedSlotsThreshold;
        ret.slotBorrowingEnabled = isSlotBorrowingEnabled;
        ret.slotAcquisitionTimeoutInMS = Math.toIntExact(waitForSlotAcquisition);
        return ret;
    }

    public RateLimiterConfig(SolrRequest.SolrRequestType requestType, RateLimiterPayload definition) {
        this.requestType = requestType;
        if (definition == null) {
            definition = EMPTY;
        }
        this.allowedRequests = definition.allowedRequests == null ? RateLimitManager.DEFAULT_CONCURRENT_REQUESTS : definition.allowedRequests;
        this.isEnabled = definition.enabled == null ? false : definition.enabled;
        this.guaranteedSlotsThreshold = definition.guaranteedSlots == null ? this.allowedRequests / 2 : definition.guaranteedSlots;
        this.isSlotBorrowingEnabled = definition.slotBorrowingEnabled == null ? false : definition.slotBorrowingEnabled;
        this.waitForSlotAcquisition = definition.slotAcquisitionTimeoutInMS == null ? -1L : definition.slotAcquisitionTimeoutInMS.longValue();
        this.definition = definition;
    }

    public boolean shouldUpdate(RateLimiterPayload definition) {
        if (definition == null) {
            definition = EMPTY;
        }
        return !definition.equals((Object)this.definition);
    }
}

