/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import org.apache.hc.client5.http.AbstractClientContextBuilder;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.cache.RequestCacheControl;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;

public class CacheContextBuilder
extends AbstractClientContextBuilder<HttpCacheContext> {
    private RequestCacheControl cacheControl;

    public static CacheContextBuilder create(SchemePortResolver schemePortResolver) {
        return new CacheContextBuilder(schemePortResolver);
    }

    public static CacheContextBuilder create() {
        return new CacheContextBuilder((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
    }

    protected CacheContextBuilder(SchemePortResolver schemePortResolver) {
        super(schemePortResolver);
    }

    public CacheContextBuilder useCookieSpecRegistry(Lookup<CookieSpecFactory> cookieSpecRegistry) {
        super.useCookieSpecRegistry(cookieSpecRegistry);
        return this;
    }

    public CacheContextBuilder useAuthSchemeRegistry(Lookup<AuthSchemeFactory> authSchemeRegistry) {
        super.useAuthSchemeRegistry(authSchemeRegistry);
        return this;
    }

    public CacheContextBuilder useCookieStore(CookieStore cookieStore) {
        super.useCookieStore(cookieStore);
        return this;
    }

    public CacheContextBuilder useCredentialsProvider(CredentialsProvider credentialsProvider) {
        super.useCredentialsProvider(credentialsProvider);
        return this;
    }

    public CacheContextBuilder useAuthCache(AuthCache authCache) {
        super.useAuthCache(authCache);
        return this;
    }

    public CacheContextBuilder preemptiveAuth(HttpHost host, AuthScheme authScheme) {
        super.preemptiveAuth(host, authScheme);
        return this;
    }

    public CacheContextBuilder preemptiveBasicAuth(HttpHost host, UsernamePasswordCredentials credentials) {
        super.preemptiveBasicAuth(host, credentials);
        return this;
    }

    public CacheContextBuilder setCacheControl(RequestCacheControl cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    protected HttpCacheContext createContext() {
        return HttpCacheContext.create();
    }

    public HttpCacheContext build() {
        HttpCacheContext context = (HttpCacheContext)super.build();
        context.setRequestCacheControl(this.cacheControl);
        return context;
    }
}

