/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.swing.AbstractAction;
import mediathek.config.MVConfig;
import mediathek.gui.dialog.DialogProgrammOrdnerOeffnen;
import mediathek.gui.messages.ProgramLocationChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.MessageBus;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UrlHyperlinkAction
extends AbstractAction {
    private static final Logger logger = LogManager.getLogger(UrlHyperlinkAction.class);

    public UrlHyperlinkAction(@NotNull String url) {
        super.putValue("Name", url);
        super.putValue("ShortDescription", url);
    }

    private static void configureAndStartCustomWebBrowser(@NotNull String url) {
        try {
            String programm = "";
            if (MVConfig.get(MVConfig.Configs.SYSTEM_URL_OEFFNEN).isEmpty()) {
                String text = "\n Der Browser zum Anzeigen der URL wird nicht gefunden.\n Browser selbst ausw\u00e4hlen.";
                DialogProgrammOrdnerOeffnen dialog = new DialogProgrammOrdnerOeffnen(MediathekGui.ui(), true, "", "Browser suchen", text);
                dialog.setVisible(true);
                if (dialog.ok) {
                    programm = dialog.ziel;
                }
            } else {
                programm = MVConfig.get(MVConfig.Configs.SYSTEM_URL_OEFFNEN);
            }
            UrlHyperlinkAction.launchApplication(programm, url);
            MVConfig.add(MVConfig.Configs.SYSTEM_URL_OEFFNEN, programm);
            MessageBus.getMessageBus().publishAsync((Object)new ProgramLocationChangedEvent());
        }
        catch (Exception ex) {
            MVConfig.add(MVConfig.Configs.SYSTEM_URL_OEFFNEN, "");
            logger.error("Failed to launch URL {} with custom browser", (Object)url);
        }
    }

    private static void launchApplication(@NotNull String app, @NotNull String url) throws IOException {
        logger.trace("trying to use xdg-open to start web browser");
        ProcessBuilder builder = new ProcessBuilder(app, url);
        Map<String, String> env = builder.environment();
        env.remove("GDK_SCALE");
        builder.start();
    }

    private static void launchMacDefaultBrowser(@NotNull String url) throws IOException {
        logger.trace("trying to launch macOS default web browser");
        ProcessBuilder builder = new ProcessBuilder("/usr/bin/osascript", "-e");
        String command = "open location \"" + url + "\"";
        builder.command().add(command);
        builder.start();
    }

    private static void launchWithJavaDesktopServices(@NotNull String url) throws Exception {
        logger.trace("trying to launch java desktop default web browser");
        Desktop d = Desktop.getDesktop();
        if (!d.isSupported(Desktop.Action.BROWSE)) {
            throw new UnsupportedOperationException("Desktop is not supported");
        }
        d.browse(new URI(url));
    }

    public static void openURI(@NotNull URI uri) {
        UrlHyperlinkAction.openURL(uri.toString());
    }

    public static void openURL(String url) {
        boolean launchFailed = false;
        if (SystemUtils.IS_OS_MAC_OSX) {
            try {
                UrlHyperlinkAction.launchMacDefaultBrowser(url);
            }
            catch (IOException e) {
                logger.error("Failed to launch default macOS web browser, using custom...", (Throwable)e);
                launchFailed = true;
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            try {
                UrlHyperlinkAction.launchApplication("xdg-open", url);
            }
            catch (IOException e) {
                logger.error("Failed to launch web browser with xdg-open", (Throwable)e);
                launchFailed = true;
            }
        } else if (Desktop.isDesktopSupported()) {
            try {
                UrlHyperlinkAction.launchWithJavaDesktopServices(url);
            }
            catch (Exception e) {
                logger.error("Failed to launch java desktop supported web browser, using custom...", (Throwable)e);
                launchFailed = true;
            }
        } else {
            logger.trace("trying to launch custom web browser");
            UrlHyperlinkAction.configureAndStartCustomWebBrowser(url);
        }
        if (launchFailed) {
            UrlHyperlinkAction.configureAndStartCustomWebBrowser(url);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UrlHyperlinkAction.openURL(e.getActionCommand());
    }
}

