/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.function.Supplier;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionRequestMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;

public interface PrivilegesEvaluator {
    default public PrivilegesEvaluationContext createContext(User user, String action) {
        return this.createContext(user, action, null, ActionRequestMetadata.empty(), null);
    }

    public PrivilegesEvaluationContext createContext(User var1, String var2, ActionRequest var3, ActionRequestMetadata<?, ?> var4, Task var5);

    public PrivilegesEvaluatorResponse evaluate(PrivilegesEvaluationContext var1);

    public boolean isClusterPermission(String var1);

    public void updateConfiguration(FlattenedActionGroups var1, SecurityDynamicConfiguration<RoleV7> var2, ConfigV7 var3);

    public void updateClusterStateMetadata(ClusterService var1);

    public void shutdown();

    public boolean notFailOnForbiddenEnabled();

    public PrivilegesEvaluatorType type();

    public static class NotInitialized
    implements PrivilegesEvaluator {
        private final Supplier<String> unavailablityReasonSupplier;

        NotInitialized(Supplier<String> unavailablityReasonSupplier) {
            this.unavailablityReasonSupplier = unavailablityReasonSupplier;
        }

        @Override
        public PrivilegesEvaluatorType type() {
            return PrivilegesEvaluatorType.NOT_INITIALIZED;
        }

        @Override
        public PrivilegesEvaluationContext createContext(User user, String action, ActionRequest actionRequest, ActionRequestMetadata<?, ?> actionRequestMetadata, Task task) {
            throw this.exception();
        }

        @Override
        public PrivilegesEvaluatorResponse evaluate(PrivilegesEvaluationContext context) {
            throw this.exception();
        }

        @Override
        public boolean isClusterPermission(String action) {
            return false;
        }

        @Override
        public void updateConfiguration(FlattenedActionGroups actionGroups, SecurityDynamicConfiguration<RoleV7> rolesConfiguration, ConfigV7 generalConfiguration) {
        }

        @Override
        public void updateClusterStateMetadata(ClusterService clusterService) {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public boolean notFailOnForbiddenEnabled() {
            return false;
        }

        private OpenSearchSecurityException exception() {
            StringBuilder error = new StringBuilder("OpenSearch Security not initialized");
            String reason = this.unavailablityReasonSupplier.get();
            if (reason != null) {
                error.append(": ").append(reason);
            } else {
                error.append(".");
            }
            return new OpenSearchSecurityException(error.toString(), RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
        }
    }

    public static enum PrivilegesEvaluatorType {
        NOT_INITIALIZED,
        STANDARD;

    }
}

