/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.classification.Classifiable;

public interface ConfusionMatrix<T extends Classifiable<T>> {
    public ImmutableOutputInfo<T> getDomain();

    public double support();

    public double support(T var1);

    public double tp(T var1);

    public double fp(T var1);

    public double fn(T var1);

    public double tn(T var1);

    public double confusion(T var1, T var2);

    default public double tp() {
        return ConfusionMatrix.sumOverOutputs(this.getDomain(), this::tp);
    }

    default public double fp() {
        return ConfusionMatrix.sumOverOutputs(this.getDomain(), this::fp);
    }

    default public double fn() {
        return ConfusionMatrix.sumOverOutputs(this.getDomain(), this::fn);
    }

    default public double tn() {
        return ConfusionMatrix.sumOverOutputs(this.getDomain(), this::tn);
    }

    default public Set<T> observed() {
        return this.getDomain().getDomain();
    }

    default public List<T> getLabelOrder() {
        return Collections.unmodifiableList(new ArrayList(this.getDomain().getDomain()));
    }

    default public void setLabelOrder(List<T> labelOrder) {
    }

    public static <T extends Classifiable<T>> double sumOverOutputs(ImmutableOutputInfo<T> domain, ToDoubleFunction<T> getter) {
        double total = 0.0;
        for (Classifiable key : domain.getDomain()) {
            total += getter.applyAsDouble(key);
        }
        return total;
    }
}

